#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// ChatGPT3_Sine wrapping circle_Mod01.fsh   by  fragcula   
//https://www.shadertoy.com/view/mlj3Wz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Prompted form ChatGPT3, if you think it ripped you off let me know, it must have gotten the code from somewhere?
// Inspired to ask ChatGPT3 by https://www.shadertoy.com/view/dljGWz (https://www.shadertoy.com/user/BitsnBobs)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalize coordinates to [-1, 1]
    vec2 uv = fragCoord/iResolution.xy*2.0-1.0;

    // Compute distance from center
    float r = length(uv);

    // Compute angle around circle
    float a = atan(uv.y, uv.x);

    // Compute sine wave
    float y = sin(a*20.0 + r*10.0 + iTime*5.0); // ChatGPT3 used iGlobalTime here.

    // Compute color from sine wave
    vec3 col = vec3(y, y*0.5+0.5, y*0.25+0.75);

    // Output color
    fragColor = vec4(col, 1.0);
/*
write a shadertoy.com fragment shader that draws a sine wave wrapped in a circle

Here is a ShaderToy fragment shader that draws a sine wave wrapped in a circle:

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalize coordinates to [-1, 1]
    vec2 uv = fragCoord/iResolution.xy*2.0-1.0;

    // Compute distance from center
    float r = length(uv);

    // Compute angle around circle
    float a = atan(uv.y, uv.x);

    // Compute sine wave
    float y = sin(a*20.0 + r*10.0 + iGlobalTime*5.0);

    // Compute color from sine wave
    vec3 col = vec3(y, y*0.5+0.5, y*0.25+0.75);

    // Output color
    fragColor = vec4(col, 1.0);
}

This shader uses the following uniforms:

    iResolution: the dimensions of the output image in pixels
    iGlobalTime: the current time in seconds

It expects a vec2 coordinate in screen space (i.e., fragCoord) and outputs a vec4 color value (i.e., fragColor). The mainImage function is the entry point for the fragment shader and is called once for each pixel of the output image.

The shader first normalizes the screen space coordinates to the range [-1, 1] using the dimensions of the output image. It then computes the distance from the center of the circle (r) and the angle around the circle (a) using the normalized coordinates.

Next, the shader computes the sine wave using the angle and distance, and uses the value of the sine wave to compute a color value. Finally, it outputs the color value as the fragment color. The sine wave is animated over time by using the iGlobalTime uniform in the computation of the sine wave.

*/
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

